/* Copyright © 2024 Com2uS Platform Corp. All Rights Reserved. */

#include "TestAppUserGameInstance.h"
#include "HIVESDKV4Tester.h"
#include "HIVESDKV4TesterGameMode.h"
#include "HiveConfiguration.h"

void UTestAppUserGameInstance::Initialize(FSubsystemCollectionBase& Collection)
{
    Super::Initialize(Collection);
    
    // 초기화
    sessionToken = TEXT("");
    nickname = TEXT("");
    serverID = TEXT("");
    gold = 0;
    gem = 0;
    isLogin = false;
    
    UE_LOG(LogTemp, Log, TEXT("TestAppUserGameInstance Initialized"));
}

void UTestAppUserGameInstance::Deinitialize()
{    
    // 리스너 언바인드
    if (updateListener.IsBound())
    {
        updateListener.Unbind();
    }
    
    Super::Deinitialize();
}

UTestAppUserGameInstance* UTestAppUserGameInstance::GetInstance(const UObject* WorldContextObject)
{
    if (!WorldContextObject)
    {
        UE_LOG(LogTemp, Error, TEXT("GetInstance: WorldContextObject is null"));
        return nullptr;
    }
    
    UWorld* World = WorldContextObject->GetWorld();
    if (!World)
    {
        UE_LOG(LogTemp, Error, TEXT("GetInstance: World is null"));
        return nullptr;
    }
    
    UGameInstance* GameInstance = World->GetGameInstance();
    if (!GameInstance)
    {
        UE_LOG(LogTemp, Error, TEXT("GetInstance: GameInstance is null"));
        return nullptr;
    }
    
    return GameInstance->GetSubsystem<UTestAppUserGameInstance>();
}

void UTestAppUserGameInstance::login()
{
    AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::IAPV4, TEXT("GameUser(POSTBOX) login try"));

    if (updateListener.IsBound())
    {
        updateListener.Unbind();
    }
    updateListener.BindUObject(this, &UTestAppUserGameInstance::gameUpdateListener);
    
    TestAppGameNetwork::login(updateListener);
    UE_LOG(LogTemp, Warning, TEXT("GameUser try login end"));
}

void UTestAppUserGameInstance::logout()
{
    AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::IAPV4, TEXT("GameUser LogOUT"));

    isLogin = false;
    nickname = TEXT("");
    gold = 0;
    gem = 0;
    sessionToken = TEXT("");
    serverID = TEXT("");
}

void UTestAppUserGameInstance::update()
{
    AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::IAPV4, TEXT("GameUser(POSTBOX) Update try"));
    // NOT_SUPPORT
}

void UTestAppUserGameInstance::loginWithCallback(TFunction<void(bool, ITestAppGameNetworkResponse)> callback)
{
    AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::IAPV4, TEXT("GameUser(POSTBOX) login try"));

    if (updateListener.IsBound())
    {
        updateListener.Unbind();
    }

    // 기존 gameUpdateListener를 래핑하여 callback 호출
    updateListener.BindLambda([this, callback](bool result, ITestAppGameNetworkResponse response) {
        // 기존 gameUpdateListener 호출
        gameUpdateListener(result, response);

        // 추가 작업 수행
        if (callback)
        {
            callback(result, response);
        }
    });

    TestAppGameNetwork::login(updateListener);
    UE_LOG(LogTemp, Warning, TEXT("GameUser try login end"));
}

void UTestAppUserGameInstance::gameUpdateListener(bool result, ITestAppGameNetworkResponse response)
{
    if (result)
    {
        AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::IAPV4, TEXT("GameUser Update Success"));

        isLogin = true;
        nickname = response.resultData->GetStringField(TEXT("nickname"));
        gold = response.resultData->GetIntegerField(TEXT("gold"));
        gem = response.resultData->GetIntegerField(TEXT("gem"));
        sessionToken = response.sessionToken;
        serverID = FHiveConfiguration::GetServerId();
    }
    else
    {
        AHIVESDKV4TesterGameMode::getGameModeInstance()->appendLogString(ELogType::IAPV4, TEXT("GameUser Update Fail"));

        isLogin = false;
        nickname = TEXT("");
        gold = -1;
        gem = -1;
        sessionToken = TEXT("");
        serverID = TEXT("");
    }
}